#include <Struct.h>

//Single, Quard, Circle, Separated, All, None, Invert
/**********************************************************/
/////////////////////////////////////////////////////////////////
//  This will select vertices, that are connected to each other
/////////////////////////////////////////////////////////////////
void SeparateSelectByVertex(tObject *obj, BOOL Deselect)
{
  if (!obj->AllowLowLevelEdit())
    return;
  if (Deselect)
    obj->VertTable->ToAllChangeFlag(FALSE, TRUE, FALSE, FALSE);
  tVertReference  VSeq;//sequence of indexed vertices
  tNormVertList Ptr = NULL;
  //Adding Vertices To Sequence
  for (VertCount=0; VertCount < obj->VertTable->VertAmount; VertCount++)
  {
    if ((obj->VertTable->Table[VertCount].Marked() || obj->VertTable->Table[VertCount].Selected() && CurrentState.IsSelectedMode()) &&
       !(obj->VertTable->Table[VertCount].Disabled() || obj->VertTable->Table[VertCount].Hidden()))
    {
      if (!VSeq.HasVertexIndex(VertCount))
        VSeq.AddVertex(0.0f,0.0f,0.0f, FALSE, VertCount);
      obj->VertTable->Table[VertCount].UnMark();
      obj->VertTable->Table[VertCount].UnSelect();
    }
  }//for: ADD

  BOOL Added = TRUE;  
  while (Added)
  {
    Added = FALSE;

    for (FaceCount=0; FaceCount < obj->FaceTable->FaceAmount; FaceCount++)
    {
      if (VSeq.HasVertexIndex(obj->FaceTable->Table[FaceCount].I1))
      {//I1 in sequence
        if (!VSeq.HasVertexIndex(obj->FaceTable->Table[FaceCount].I2) && !(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Disabled() || obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Hidden()))
        {
          VSeq.AddVertex(0.0f,0.0f,0.0f, FALSE, obj->FaceTable->Table[FaceCount].I2);
          Added = TRUE;
        }
        if (!VSeq.HasVertexIndex(obj->FaceTable->Table[FaceCount].I3) && !(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Disabled() || obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Hidden()))
        {
          VSeq.AddVertex(0.0f,0.0f,0.0f, FALSE, obj->FaceTable->Table[FaceCount].I3);
          Added = TRUE;
        }
      }
      if (VSeq.HasVertexIndex(obj->FaceTable->Table[FaceCount].I2))
      {//I2 in sequence
        if (!VSeq.HasVertexIndex(obj->FaceTable->Table[FaceCount].I1) && !(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Disabled() || obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Hidden()))
        {
          VSeq.AddVertex(0.0f,0.0f,0.0f, FALSE, obj->FaceTable->Table[FaceCount].I1);
          Added = TRUE;
        }
        if (!VSeq.HasVertexIndex(obj->FaceTable->Table[FaceCount].I3) && !(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Disabled() || obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Hidden()))
        {
          VSeq.AddVertex(0.0f,0.0f,0.0f, FALSE, obj->FaceTable->Table[FaceCount].I3);
          Added = TRUE;
        }
      }
      if (VSeq.HasVertexIndex(obj->FaceTable->Table[FaceCount].I3))
      {//I3 in sequence
        if (!VSeq.HasVertexIndex(obj->FaceTable->Table[FaceCount].I1) && !(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Disabled() || obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Hidden()))
        {
          VSeq.AddVertex(0.0f,0.0f,0.0f, FALSE, obj->FaceTable->Table[FaceCount].I1);
          Added = TRUE;
        }
        if (!VSeq.HasVertexIndex(obj->FaceTable->Table[FaceCount].I2) && !(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Disabled() || obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Hidden()))
        {
          VSeq.AddVertex(0.0f,0.0f,0.0f, FALSE, obj->FaceTable->Table[FaceCount].I2);
          Added = TRUE;
        }
      }
    }//for
  }//while: FIND

  Ptr = VSeq.GetFirst();
  while (Ptr)
  {
    obj->VertTable->Table[Ptr->Index].Select();
    Ptr = Ptr->Next;
  }

  if (Deselect)
    obj->VertTable->ToAllChangeFlag(FALSE, TRUE, FALSE, FALSE);
  obj->nRequire = Z3D_PLUGRESULT_UPDATEWIRE;
}//select by vertex


BOOL IsNeighbourFaces(tObject *obj, long ind1, long ind2)
{
  return
    (
      //1-2
      ((obj->FaceTable->Table[ind1].I1 == obj->FaceTable->Table[ind2].I1) &&
       (obj->FaceTable->Table[ind1].I2 == obj->FaceTable->Table[ind2].I3))
      ||
      ((obj->FaceTable->Table[ind1].I1 == obj->FaceTable->Table[ind2].I3) &&
       (obj->FaceTable->Table[ind1].I2 == obj->FaceTable->Table[ind2].I2))
      ||
      ((obj->FaceTable->Table[ind1].I1 == obj->FaceTable->Table[ind2].I2) &&
       (obj->FaceTable->Table[ind1].I2 == obj->FaceTable->Table[ind2].I1))
      ||
      //2-3
      ((obj->FaceTable->Table[ind1].I2 == obj->FaceTable->Table[ind2].I1) &&
       (obj->FaceTable->Table[ind1].I3 == obj->FaceTable->Table[ind2].I3))
      ||
      ((obj->FaceTable->Table[ind1].I2 == obj->FaceTable->Table[ind2].I3) &&
       (obj->FaceTable->Table[ind1].I3 == obj->FaceTable->Table[ind2].I2))
      ||
      ((obj->FaceTable->Table[ind1].I2 == obj->FaceTable->Table[ind2].I2) &&
       (obj->FaceTable->Table[ind1].I3 == obj->FaceTable->Table[ind2].I1))
      ||
      //3-1
      ((obj->FaceTable->Table[ind1].I3 == obj->FaceTable->Table[ind2].I1) &&
       (obj->FaceTable->Table[ind1].I1 == obj->FaceTable->Table[ind2].I3))
      ||
      ((obj->FaceTable->Table[ind1].I3 == obj->FaceTable->Table[ind2].I3) &&
       (obj->FaceTable->Table[ind1].I1 == obj->FaceTable->Table[ind2].I2))
      ||
      ((obj->FaceTable->Table[ind1].I3 == obj->FaceTable->Table[ind2].I2) &&
       (obj->FaceTable->Table[ind1].I1 == obj->FaceTable->Table[ind2].I1))
    );
}// are neightbour faces ???


/////////////////////////////////////////////////////////////////
//    This will select Faces, that are connected with an edge
/////////////////////////////////////////////////////////////////
void SeparateSelectByFaces(tObject *obj, BOOL Deselect)
{
  if (!obj->AllowLowLevelEdit())
    return;
  if (Deselect)
    obj->FaceTable->ToAllChangeFlag(FALSE, TRUE, FALSE, FALSE);

  tVertReference  VSeq;//sequence of indexed vertices
  tNormVertList Ptr = NULL;
  //Adding Vertices To Sequence
  for (FaceCount=0; FaceCount < obj->FaceTable->FaceAmount; FaceCount++)
  {
    if ((obj->FaceTable->Table[FaceCount].Marked() || obj->FaceTable->Table[FaceCount].Selected() && CurrentState.IsSelectedMode()) &&
      !(obj->FaceTable->Table[FaceCount].Disabled() || obj->FaceTable->Table[FaceCount].Hidden()))
    {
      if (!VSeq.HasVertexIndex(FaceCount))
        VSeq.AddVertex(0.0f,0.0f,0.0f, FALSE, FaceCount);
      obj->FaceTable->Table[FaceCount].UnMark();
      obj->FaceTable->Table[FaceCount].UnSelect();
    }
  }//for: ADD

  Ptr = VSeq.GetFirst();
  while (Ptr)
  {
    for (FaceCount=0; FaceCount < obj->FaceTable->FaceAmount; FaceCount++)
    {
      if (IsNeighbourFaces(obj, Ptr->Index, FaceCount) && !VSeq.HasVertexIndex(FaceCount))
      {//Check Add this face to the set
        if (!(obj->FaceTable->Table[FaceCount].Disabled() || obj->FaceTable->Table[FaceCount].Hidden()))
          VSeq.AddVertex(0.0f,0.0f,0.0f, FALSE, FaceCount);
      }//Check Add this face to the set
    }//for
    Ptr = Ptr->Next;//VSeq.GetLast();
  }//while: FIND

  Ptr = VSeq.GetFirst();
  while (Ptr)
  {
    obj->FaceTable->Table[Ptr->Index].Select();
    Ptr = Ptr->Next;
  }
  if (Deselect)
    obj->FaceTable->ToAllChangeFlag(FALSE, TRUE, FALSE, FALSE);
  obj->nRequire = Z3D_PLUGRESULT_UPDATEWIRE;
}//select by face






DWORD CALLBACK SingleOnRButtonDown(tProcParams* params)
{
  /////////////////////////////////////////
  //Processing Selection Here
  /////////////////////////////////////////

  //////////////////////////////////////////
  // using standart flags backup function
  /////////////////////////////////////////
  if (CurrentState.UndoMaxSteps > 0)  
    Backup(Z3D_BACKUP_FLAGS, "Single selection", FALSE, params);
  
  if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS))
  {
    params->Objects->ToHasFlagChangeFlag(TRUE, FALSE, FALSE, FALSE,
              FALSE, FALSE, FALSE, TRUE,
              FALSE, TRUE, FALSE, FALSE);
    return Z3D_PLUGRESULT_SELECTIONCHANGED | Z3D_PLUGRESULT_UPDATEWIRE;
  }
  if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
  {
    for (ObjCount=0 ; ObjCount < params->Objects->ObjAmount ; ObjCount++)
    {
      params->Objects->ObjSet[ObjCount].FaceTable->ToHasFlagChangeFlag(
              TRUE, FALSE, FALSE, FALSE,
              FALSE, FALSE, FALSE, TRUE,
              FALSE, TRUE, FALSE, FALSE);
      params->Objects->ObjSet[ObjCount].nRequire = Z3D_PLUGRESULT_UPDATEWIRE;
    }
    return Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  if (CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
  {
    for (ObjCount=0 ; ObjCount < params->Objects->ObjAmount ; ObjCount++)
    {
      params->Objects->ObjSet[ObjCount].VertTable->ToHasFlagChangeFlag(
        TRUE, FALSE, FALSE, FALSE,
        FALSE, FALSE, FALSE, TRUE,
        FALSE, TRUE, FALSE, FALSE);
      params->Objects->ObjSet[ObjCount].nRequire = Z3D_PLUGRESULT_UPDATEWIRE;
    }
    return Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  return 0;
}



DWORD CALLBACK InvertOnRButtonDown(tProcParams* params)
{
  //////////////////////////////////////////
  // using standart flags backup function
  /////////////////////////////////////////
  
  if (CurrentState.UndoMaxSteps > 0)  
    Backup(Z3D_BACKUP_FLAGS, "Invert selection", FALSE, params);

  if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS))
  {
    params->Objects->ToAllChangeFlag(FALSE, TRUE, FALSE, FALSE);
    return Z3D_PLUGRESULT_SELECTIONCHANGED | Z3D_PLUGRESULT_UPDATEWIRE;
  }
  if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
  {
    for (ObjCount=0; ObjCount < params->Objects->ObjAmount; ObjCount++)
    {
      if ((params->Objects->ObjSet[ObjCount].Marked()/* && !CurrentState.IsSelectedMode()*/) || (params->Objects->ObjSet[ObjCount].Selected() && CurrentState.IsSelectedMode()))
        params->Objects->ObjSet[ObjCount].FaceTable->ToAllChangeFlag(FALSE, TRUE, FALSE, FALSE);
      params->Objects->ObjSet[ObjCount].nRequire = Z3D_PLUGRESULT_UPDATEWIRE;
    }
    return Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  if (CurrentState.IsLevel(Z3D_LEVEL_VERTICES))
  {
    for (ObjCount=0; ObjCount < params->Objects->ObjAmount; ObjCount++)
    {
      if ((params->Objects->ObjSet[ObjCount].Marked()/* && !CurrentState.IsSelectedMode()*/) || (params->Objects->ObjSet[ObjCount].Selected() && CurrentState.IsSelectedMode()))
        params->Objects->ObjSet[ObjCount].VertTable->ToAllChangeFlag(FALSE, TRUE, FALSE, FALSE);
      params->Objects->ObjSet[ObjCount].nRequire = Z3D_PLUGRESULT_UPDATEWIRE;
    }
    return Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  return 0;
}


DWORD CALLBACK AllOnRButtonDown(tProcParams* params)
{
  //////////////////////////////////////////
  // using standart flags backup function
  /////////////////////////////////////////
  
  if (CurrentState.UndoMaxSteps > 0)  
    Backup(Z3D_BACKUP_FLAGS, "Select All", FALSE, params);

  if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS))
  {
    params->Objects->SelectAll();
    return Z3D_PLUGRESULT_SELECTIONCHANGED | Z3D_PLUGRESULT_UPDATEWIRE;
  }
  if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
  {
    for (ObjCount=0; ObjCount < params->Objects->ObjAmount; ObjCount++)  if ((params->Objects->ObjSet[ObjCount].Marked()/* && !CurrentState.IsSelectedMode()*/) || (params->Objects->ObjSet[ObjCount].Selected() && CurrentState.IsSelectedMode())) params->Objects->ObjSet[ObjCount].FaceTable->SelectAll();
    return Z3D_PLUGRESULT_REDRAW | Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  if (CurrentState.IsLevel(Z3D_LEVEL_VERTICES))
  {
    for (ObjCount=0; ObjCount < params->Objects->ObjAmount; ObjCount++)  if ((params->Objects->ObjSet[ObjCount].Marked()/* && !CurrentState.IsSelectedMode()*/) || (params->Objects->ObjSet[ObjCount].Selected() && CurrentState.IsSelectedMode())) params->Objects->ObjSet[ObjCount].VertTable->SelectAll();
    return Z3D_PLUGRESULT_REDRAW | Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  return 0;
}


DWORD CALLBACK NoneOnRButtonDown(tProcParams* params)
{
  //////////////////////////////////////////
  // using standart flags backup function
  /////////////////////////////////////////
  
  if (CurrentState.UndoMaxSteps > 0)  
    Backup(Z3D_BACKUP_FLAGS, "Deselect All", FALSE, params);

  if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS))
  {
    params->Objects->UnSelectAll();
    return Z3D_PLUGRESULT_REDRAW | Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
  {
    for (ObjCount=0; ObjCount < params->Objects->ObjAmount; ObjCount++)  if ((params->Objects->ObjSet[ObjCount].Marked()/* && !CurrentState.IsSelectedMode()*/) || (params->Objects->ObjSet[ObjCount].Selected() && CurrentState.IsSelectedMode())) params->Objects->ObjSet[ObjCount].FaceTable->UnSelectAll();
    return Z3D_PLUGRESULT_REDRAW | Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  if (CurrentState.IsLevel(Z3D_LEVEL_VERTICES))
  {
    for (ObjCount=0; ObjCount < params->Objects->ObjAmount; ObjCount++)  if ((params->Objects->ObjSet[ObjCount].Marked()/* && !CurrentState.IsSelectedMode()*/) || (params->Objects->ObjSet[ObjCount].Selected() && CurrentState.IsSelectedMode())) params->Objects->ObjSet[ObjCount].VertTable->UnSelectAll();
    return Z3D_PLUGRESULT_REDRAW | Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  return 0;
}



DWORD CALLBACK SeparatedOnRButtonDown(tProcParams* params)
{
  //////////////////////////////////////////
  // using standart flags backup function
  /////////////////////////////////////////
  
  if (CurrentState.UndoMaxSteps > 0)  
    Backup(Z3D_BACKUP_FLAGS, "Separated selection", FALSE, params);

  if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
  {
    for (ObjCount=0; ObjCount < params->Objects->ObjAmount; ObjCount++)
      SeparateSelectByFaces(&params->Objects->ObjSet[ObjCount], (*params->nFlags & MK_CONTROL)==MK_CONTROL);
    return Z3D_PLUGRESULT_REDRAW | Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  if (CurrentState.IsLevel(Z3D_LEVEL_VERTICES))
  {
    for (ObjCount=0; ObjCount < params->Objects->ObjAmount; ObjCount++)
      SeparateSelectByVertex(&params->Objects->ObjSet[ObjCount], (*params->nFlags & MK_CONTROL)==MK_CONTROL);
    return Z3D_PLUGRESULT_REDRAW | Z3D_PLUGRESULT_SELECTIONCHANGED;
  }
  return 0;
}


DWORD CALLBACK UVMappedOnRButtonDown(tProcParams* params)
{
  //////////////////////////////////////////
  // using standard flags backup function
  /////////////////////////////////////////
  if (!CurrentState.IsLevel(Z3D_LEVEL_FACES))
    return 0;
  
  if (CurrentState.UndoMaxSteps > 0)  
    Backup(Z3D_BACKUP_FLAGS, "Select UV-mapped", FALSE, params);

  for (ObjCount=0; ObjCount < params->Objects->ObjAmount; ObjCount++)
    if (params->Objects->ObjSet[ObjCount].Marked() &&
        params->Objects->ObjSet[ObjCount].AllowGenericEdit())
    {
      for (FaceCount=0; FaceCount < params->Objects->ObjSet[ObjCount].FaceTable->FaceAmount; FaceCount++)
        if ((params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].U1 != 0.0f) ||
            (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].V1 != 0.0f) ||
            (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].U2 != 0.0f) ||
            (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].V1 != 0.0f) ||
            (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].U3 != 0.0f) ||
            (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].V3 != 0.0f))
        {
          if (*params->nFlags & MK_CONTROL)
            params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].UnSelect();
          else
            params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].Select();
        }
      params->Objects->ObjSet[ObjCount].nRequire |= Z3D_PLUGRESULT_UPDATEWIRE;
    }
  return Z3D_PLUGRESULT_REDRAW | Z3D_PLUGRESULT_SELECTIONCHANGED;
}